function betagal = partition_func_4_fudge(AHL,CI,AHL_CI_fnc)
%
% Determines betagal levels at each location
%

betagal = zeros(size(AHL,2),1);

fprintf('\nCompute AHL,CI --> betagal mapping with fudge factors (total vals = %d)\n', ...
    size(AHL,2));

fA = AHL_fudge(AHL);
fC = CI_fudge (CI);

for i=1:size(AHL,2)
    %betagal(i) = AHL_CI_fnc(fA(i), fC(i));
    % surface fit was done with log of the inputs and outputs
    betagal(i) = 10^(AHL_CI_fnc(log10(fA(i)), log10(fC(i))));
    if ((i/1000) == floor(i/1000))
        fprintf(1,'%d: %f,%f --> %f\n',i,fA(i),fC(i),betagal(i));
    end
end

return;

